﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Timers;
using System.Threading;
using System.IO;
using System.Runtime.InteropServices;

namespace FleetPC_4_E
{
    public partial class CSharpExample : Form
    {

        [DllImport("inpout32.dll")]
        private static extern UInt32 IsInpOutDriverOpen();
        [DllImport("inpout32.dll")]
        private static extern void Out32(UInt16 PortAddress, UInt32 Data);
        [DllImport("inpout32.dll")]
        //private static extern char Inp32(UInt16 PortAddress);
        private static extern UInt32 Inp32(UInt16 PortAddress);


        [DllImport("inpout32.dll")]
        private static extern void DlPortWritePortUshort(short PortAddress, ushort Data);
        [DllImport("inpout32.dll")]
        private static extern ushort DlPortReadPortUshort(short PortAddress);

        [DllImport("inpout32.dll")]
        private static extern void DlPortWritePortUlong(int PortAddress, uint Data);
        [DllImport("inpout32.dll")]
        private static extern uint DlPortReadPortUlong(int PortAddress);

        [DllImport("inpout32.dll")]
        private static extern bool IsXP64Bit();
        [DllImport("inpout32.dll")]
        private static extern int Opendriver(bool bX64);
        [DllImport("inpout32.dll")]
        private static extern void Closedriver();


        [DllImport("inpoutx64.dll")]
        private static extern bool GetPhysLong(ref int PortAddress, ref uint Data);
        [DllImport("inpoutx64.dll")]
        private static extern bool SetPhysLong(ref int PortAddress, ref uint Data);


        [DllImport("inpoutx64.dll", EntryPoint = "IsInpOutDriverOpen")]
        private static extern UInt32 IsInpOutDriverOpen_x64();
        [DllImport("inpoutx64.dll", EntryPoint = "Out32")]
        private static extern void Out32_x64(UInt16 PortAddress, UInt32 Data);
        [DllImport("inpoutx64.dll", EntryPoint = "Inp32")]
        //private static extern char Inp32_x64(UInt16 PortAddress);
        private static extern UInt32 Inp32_x64(UInt16 PortAddress);

        [DllImport("inpoutx64.dll", EntryPoint = "DlPortWritePortUshort")]
        private static extern void DlPortWritePortUshort_x64(short PortAddress, ushort Data);
        [DllImport("inpoutx64.dll", EntryPoint = "DlPortReadPortUshort")]
        private static extern ushort DlPortReadPortUshort_x64(short PortAddress);

        [DllImport("inpoutx64.dll", EntryPoint = "DlPortWritePortUlong")]
        private static extern void DlPortWritePortUlong_x64(int PortAddress, uint Data);
        [DllImport("inpoutx64.dll", EntryPoint = "DlPortReadPortUlong")]
        private static extern uint DlPortReadPortUlong_x64(int PortAddress);

        [DllImport("inpoutx64.dll", EntryPoint = "GetPhysLong")]
        private static extern bool GetPhysLong_x64(ref int PortAddress, ref uint Data);
        [DllImport("inpoutx64.dll", EntryPoint = "SetPhysLong")]
        private static extern bool SetPhysLong_x64(ref int PortAddress, ref uint Data);

        [DllImport("inpoutx64.dll", EntryPoint = "IsXP64Bit")]
        private static extern bool IsXP64Bit_x64();
        [DllImport("inpoutx64.dll", EntryPoint = "Opendriver")]
        private static extern int Opendriver_x64(bool bX64);
        [DllImport("inpoutx64.dll", EntryPoint = "Closedriver")]
        private static extern void Closedriver_x64();


        bool m_bX64 = false;

        public CSharpExample()
        {
            InitializeComponent();
            Driver_Check();
            SPIO_INI();
        }

        private void Driver_Check()
        {
            uint nResult = 0;

            nResult = IsInpOutDriverOpen();
            m_bX64 = IsXP64Bit();
            if (nResult == 0)
            {
                Opendriver(m_bX64);
                //MessageBox.Show("Create driver");
                Closedriver();
            }

        }

        private void SMB_Write(UInt16 SMB_Addr, UInt16 DEV_Address, UInt16 DEV_Reg, UInt16 Value)
        {
            Out32(SMB_Addr, 0xFF);                                              // Clear SMBUS Status
            Thread.Sleep(10);                                                  // Delay 10 ms (1000 is 1 Sec) 
            Out32((ushort)(SMB_Addr + 0x04), DEV_Address);                      // EEPROM Address AE -Write / AF -Read
            Thread.Sleep(10);
            Out32((ushort)(SMB_Addr + 0x03), DEV_Reg);                          // EEPROM Reg Address
            Thread.Sleep(10);
            Out32((ushort)(SMB_Addr + 0x05), Value);                            // Write Data in EEPROM
            Thread.Sleep(10);
            Out32((ushort)(SMB_Addr + 0x02), 0x48);                             // Start to Send 
            Thread.Sleep(10);

        }

        private UInt32 SMB_Read(UInt16 SMB_Addr, UInt16 DEV_Address, UInt16 DEV_Reg)
        {
            UInt32 Value;
            Out32(SMB_Addr, 0xFF);                                              // Clear SMBUS Status
            Thread.Sleep(10);                                                  // Delay 10 ms (1000 is 1 Sec) 
            Out32((ushort)(SMB_Addr + 0x04), (ushort)(DEV_Address + 1));         // EEPROM Address AE -Write / AF -Read
            Thread.Sleep(10);
            Out32((ushort)(SMB_Addr + 0x03), DEV_Reg);                          // EEPROM Reg Address
            Thread.Sleep(10);
            Out32((ushort)(SMB_Addr + 0x02), 0x48);                             // Start to Send 
            Thread.Sleep(10);
            Value = Inp32((ushort)(SMB_Addr + 0x05));                           // Read Data in EEPROM
            Thread.Sleep(10);
            return Value;
        }

        private void SPIO_INI()
        {
            Out32(0x2E, 0x87);                                                  // Super I/O entry key Two 0x87 
            Out32(0x2E, 0x87);
            Out32(0x2E, 0x07);
            Out32(0x2F, 0x06);                                                  // Jump in GPIO
            Out32(0x2E, 0x30);                                                  // Set Base Address Reg 0x30
            Out32(0x2F, 0x01);                                                  // Set Base Address to Enabled
            Out32(0x2E, 0x0aa);                                                 // Exit Super I/O
        }

        private void DIO_Write(UInt32 DIO_Port, UInt32 DIO_Value)
        {
            Out32(0x2E, 0x87);                                                  // Super I/O entry key Two 0x87 
            Out32(0x2E, 0x87);
            Out32(0x2E, 0x07);
            Out32(0x2F, 0x06);                                                  // Jump in GPIO
            Out32(0x2E, DIO_Port);                                                  // Set Base Address Reg 0x30
            Out32(0x2F, DIO_Value);                                                  // Set Base Address to Enabled
            Out32(0x2E, 0x0aa);                                                 // Exit Super I/O
        }

        private UInt32 DIO_Read(UInt32 DIO_Port)
        {
            UInt32 PortVal;

            Out32(0x2E, 0x87);                                                  // Super I/O entry key Two 0x87 
            Out32(0x2E, 0x87);
            Out32(0x2E, 0x07);
            Out32(0x2F, 0x06);                                                  // Jump in GPIO
            Out32(0x2E, DIO_Port);                                              // Set DIO port
            PortVal = Inp32(0x2F);
            Out32(0x2E, 0x0aa);                                                 // Exit Super I/O


            return PortVal;
        }


        private void button3_Click(object sender, EventArgs e)
        {
            UInt32 PortVal;
            UInt32 DohVal;

            DIO_Write(0xF0, 0x04);

            PortVal = DIO_Read(0xF2);

            DohVal = PortVal & 0xFB;                                            // Set bit2 to "0" and keep others to original value 

            DIO_Write(0xF1, DohVal);

            Thread.Sleep(2000);                                                 // Delay 2 Sec (1000 is 1 Sec) 

            DohVal = PortVal | 0x04;                                            // Set bit2 to "1" and keep others to original value 
            DIO_Write(0xF1, DohVal);


        }

        private void button11_Click(object sender, EventArgs e)
        {
            UInt32 Delay_Value;     // Power Off Delay Time Value

            Delay_Value = UInt32.Parse(textBox4.Text, System.Globalization.NumberStyles.HexNumber);
            SMB_Write(0xF040, 0xAE, 0x31, (UInt16)Delay_Value);         // SMB address:0xF04; Device address: 0xAE; Delay Time setting Reg: 0x31
        }

        private void button12_Click(object sender, EventArgs e)
        {
            UInt32 Delay_Value;     // Power Off Delay Time Value
            Delay_Value = SMB_Read(0xF040, 0xAE, 0x31);
            textBox4.Text = Delay_Value.ToString("X");
        }

        private void button1_Click(object sender, EventArgs e)
        {
            UInt32 PortVal;
            UInt32 IgnVal;

            PortVal = DIO_Read(0xF2);
            IgnVal = PortVal & 0x08;    // Only Read GPI bit3
            if (IgnVal == 0x08)         // If bit3 = 1 --> Ignition is On
            {
                MessageBox.Show("Ignition is On (High)", "FleetPC-4-E Test Tools V1.0", MessageBoxButtons.OK, MessageBoxIcon.Information);
                radioButton1.Checked = true;
            }
            else if (IgnVal == 0x00)    // If bit3 = 0 --> Ignition is Off
            {
                MessageBox.Show("Ignition is Off (Low)", "FleetPC-4-E Test Tools V1.0", MessageBoxButtons.OK, MessageBoxIcon.Information);
                radioButton2.Checked = true;
            }

        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button16_Click(object sender, EventArgs e)
        {
            UInt32 UPS_Off_Value;       // UPS Power Off Delay Time Value
            UPS_Off_Value = UInt32.Parse(textBox9.Text, System.Globalization.NumberStyles.HexNumber);
            SMB_Write(0xF040, 0xAE, 0x32, (UInt16)UPS_Off_Value);         // SMB address:0xF04; Device address: 0xAE; Delay Time setting Reg: 0x32
        }

        private void button15_Click(object sender, EventArgs e)
        {
            UInt32 UPS_Value;
            UPS_Value = SMB_Read(0xF040, 0xAE, 0x32);
            textBox9.Text = UPS_Value.ToString("X");    // Display UPS Power Off Delay time to textBox9

        }

        private void button25_Click(object sender, EventArgs e)
        {
            UInt32 UPS_Mode;
            UPS_Mode = SMB_Read(0xF040, 0xAE, 0x33);
            textBox9.Text = UPS_Mode.ToString("X");    // Display UPS Power Off Delay time to textBox9
            if (UPS_Mode == 0xAA)
            {
                MessageBox.Show("Normal Operating Mode", "FleetPC-4-E Test Tools V1.0", MessageBoxButtons.OK, MessageBoxIcon.Information);

            }
            else
            {
                MessageBox.Show("UPS Mode is ON", "FleetPC-4-E Test Tools V1.0", MessageBoxButtons.OK, MessageBoxIcon.Information);

            }

        }

        private void button28_Click(object sender, EventArgs e)
        {
            UInt32 Firmware_Ver;
            Firmware_Ver = SMB_Read(0xF040, 0xAE, 0x13);
            textBox11.Text = Firmware_Ver.ToString("X");    // Display Firmware Version to textBox11
        }

        private void button8_Click(object sender, EventArgs e)
        {
            UInt32 PortVal;
            UInt32 DiVal;
            PortVal = DIO_Read(0xA2);
            DiVal = PortVal & 0x03; // bit 0-3 for Digital Input Status
            textBox3.Text = PortVal.ToString("X");
            
            if (DiVal == 0x01)
            {
                MessageBox.Show("DI1 is High | DI2 is Low ", "FleetPC-4-E Test Tools V1.0", MessageBoxButtons.OK, MessageBoxIcon.None);
            }
            else if (DiVal == 0x02)
            {
                MessageBox.Show("DI2 is High | DI1 is Low ", "FleetPC-4-E Test Tools V1.0", MessageBoxButtons.OK, MessageBoxIcon.None);
            }

            else if (DiVal == 0x03)
            {
                MessageBox.Show("DI1 and DI2 are  High ", "FleetPC-4-E Test Tools V1.0", MessageBoxButtons.OK, MessageBoxIcon.None);
            }

            else if (DiVal == 0x00)
            {
                MessageBox.Show("DI1 and DI2 are Low", "FleetPC-4-E Test Tools V1.0", MessageBoxButtons.OK, MessageBoxIcon.None);
            }

            else
            {
                MessageBox.Show("Test Fail", "FleetPC-4-E Test Tools V1.0", MessageBoxButtons.OK, MessageBoxIcon.Error);

            }

        }

        private void button17_Click(object sender, EventArgs e)
        {
            UInt32 PortVal;
            UInt32 DohVal;
            PortVal = DIO_Read(0xA2);
            textBox3.Text = PortVal.ToString("X");

            DohVal = PortVal | 0x10;  // Set bit4 to "1" and keep others to original value 

            DIO_Write(0xA1, DohVal);

        }

        private void button24_Click(object sender, EventArgs e)
        {
            UInt32 PortVal;
            UInt32 DohVal;
            PortVal = DIO_Read(0xA2);
            textBox3.Text = PortVal.ToString("X");

            DohVal = PortVal & 0xEF;  // Set bit4 to "0" and keep others to original value 

            DIO_Write(0xA1, DohVal);
        }

        private void button18_Click(object sender, EventArgs e)
        {
            UInt32 PortVal;
            UInt32 DohVal;
            PortVal = DIO_Read(0xA2);
            textBox3.Text = PortVal.ToString("X");

            DohVal = PortVal | 0x20;   // Set bit5 to "1" and keep others to original value 

            DIO_Write(0xA1, DohVal);
        }

        private void button23_Click(object sender, EventArgs e)
        {
            UInt32 PortVal;
            UInt32 DohVal;
            PortVal = DIO_Read(0xA2);
            textBox3.Text = PortVal.ToString("X");

            DohVal = PortVal & 0xDF;    // Set bit5 to "0" and keep others to original value 

            DIO_Write(0xA1, DohVal);
        }

        private void button27_Click(object sender, EventArgs e)
        {
            UInt32 TempVal;
            int temp2;

            Out32(0x295, 0x74);     //Set Temp2 (74h) to Hardware Monitor Address Port (295h) 
            TempVal = Inp32(0x296);

            //------------------ Hex to Dec ---------------------------------------

            temp2 = Convert.ToInt32(TempVal);
            textBox10.Text = temp2.ToString();
        }

        private void button29_Click(object sender, EventArgs e)
        {
            Out32(0xA1A, 0x01);         // Set watchdog timer value to 10
            Out32(0xA16, 0x0A);         // Set watchdog timer value to 10
            Out32(0xA15, 0x32);         // Set watchdog timer unit is sec and enable watchdog
        }









    }
}
